/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;

import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.NotesException;

/**
 * @author Thomas Ekert
 *
 */
public class Newsletter {
	
	protected static final int NEWSLETTER_ERROR = 9999;
	private static final String DEFAULT_SENDER = "thomas@ekert.de";
	private static final String DEFAULT_ATTACHMENT = "data/binary.gif";
	public static final int SEND_ERROR = -1;

	private AgentContext ac = null;
	private Database db = null;
	private NLDocument nldoc = null;
	
	/**
	 * Newsletterobjekt, das aus dem AgentContext gebildet wird.
	 * @param context
	 * @throws NotesException
	 */
	public Newsletter (AgentContext context) throws NotesException {
		if (context==null) {
			throw new NotesException (NEWSLETTER_ERROR, "AgentContext darf nicht null sein.");
		}
		ac = context;
		db = ac.getCurrentDatabase();
		nldoc = NLDocument.getInstance(ac.getDocumentContext());
		if (nldoc == null || !nldoc.isActive()) {
			throw new NotesException (NEWSLETTER_ERROR, "Kein NL oder nicht aktiv.");
		}
	}
	
	/**
	 * Versendet den Newsletter an die gewnschten Empfnger.
	 * @return
	 */
	public int send () {
		EmailNotes email = null;
		try {
			email = new EmailNotes(db.getParent(), db.getServer());
			email.setSender(DEFAULT_SENDER);
			email.setSubject(nldoc.getSubject());
			email.setMessage(nldoc.getBody());
			email.setAttachFileName(DEFAULT_ATTACHMENT);
			// versendet alle emails einzeln. Alternativ kann email.send 
			// auch alle auf einmal senden, indem per email.setRecipient (String [] rec)
			// alle Empfnger gesetzt werden.
			int count = 0;
			for (int i = 0; i < nldoc.getRecipients().size(); i++) {
				email.setRecipient((String)nldoc.getRecipients().elementAt(i));
				boolean done=email.send();
				if (done) {count++;}
				System.out.println("Email an: "
					+ email.getRecipientArray()[0]
					+ (done ? " verschickt."
							: " nicht verschickt."));
			}
			if (count != nldoc.getRecipients().size()) {
				return SEND_ERROR;
			} else {
				return count;
			}
		} catch (NotesException e) {
			return SEND_ERROR;
		} catch (MessageException e) {
			return SEND_ERROR;
		} finally {
			if (email != null) {email.recycle();}
		}
	}
}
